#   Cisco Secure Network Analytics Flow Collectors

## Flow Data Collection

- Flow Collectors receive flow data from existing network devices (routers and switches).
- These devices export flow information to the Flow Collectors.

## Flow Processing Functions

### Aggregation and Normalization

- Flow Collectors aggregate multiple flow data streams.
- Normalization standardizes the flow data before sending it to the Manager.

### Flow Stitching

- NetFlow produces unidirectional records, creating two records for each session.
- Flow Collectors combine (stitch) these records, providing a complete, bidirectional view of each network session.

### Flow Deduplication

- Multiple flow exporters may report the same flow, resulting in duplicate records.
- Flow Collectors use built-in deduplication techniques to remove duplicates while preserving unique information.

### Correlation and Reduction

- Flow Collectors correlate flow data into fewer, more meaningful flow records.
- This reduces the investigation time for network analysis.

## Flow Records

### Conversational Flow Records

- Stitched flow records represent end-to-end communications between hosts.
- These records answer key questions: who, when, where, what, and how regarding the network flow.

---

**Summary:**  
Flow Collectors in Cisco Secure Network Analytics aggregate, normalize, stitch, and deduplicate flow data from existing devices, resulting in clear, concise conversational flow records that facilitate efficient network analysis.